<?php
session_start(); // Ensure session is started here

// Verifica se o usuário está autenticado
if (!isset($_SESSION["username"])) {
    header('Location: painel.php'); // Redireciona para o painel de login
    exit;
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Painel Responsivo com Dark Mode</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    tailwind.config = {
      darkMode: 'class'
    }
  </script>
</head>
<body class="bg-gray-100 dark:bg-gray-900">

  <!-- Cabeçalho -->
  <header class="w-full h-16 bg-white dark:bg-gray-800 shadow flex items-center justify-between px-6">
    <div class="flex items-center gap-4">
      <button id="menuToggle" class="block md:hidden text-2xl text-gray-700 dark:text-gray-200">☰</button>
      <div class="text-2xl font-bold text-gray-700 dark:text-gray-100">Painel</div>
    </div>

    <div class="flex items-center gap-4">
      <button id="toggleDark" class="px-4 py-2 bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-200 rounded hover:bg-gray-300 dark:hover:bg-gray-600">🌙/☀</button>
      <div class="text-gray-500 dark:text-gray-300 hidden sm:block">Bem-vindo, <?php echo htmlspecialchars($_SESSION["username"]); ?></div>
    </div>
  </header>

  <div class="flex">

    <!-- Menu Lateral -->
    <aside id="sidebar" class="w-64 bg-white dark:bg-gray-800 h-[calc(100vh-4rem)] shadow-md fixed md:static top-16 left-0 transform -translate-x-full md:translate-x-0 transition-transform duration-300 z-50">
      <nav class="flex flex-col p-4 space-y-2">
        <a href="dashboard.php" class="p-3 rounded hover:bg-blue-100 dark:hover:bg-blue-900 flex items-center">
          <span class="text-gray-700 dark:text-gray-200">🏠 Dashboard</span>
        </a>
        <a href="servidores.php" class="p-3 rounded hover:bg-blue-100 dark:hover:bg-blue-900 flex items-center">
          <span class="text-gray-700 dark:text-gray-200">🖥 Servidores</span>
        </a>
        <a href="admin.php" class="p-3 rounded hover:bg-blue-100 dark:hover:bg-blue-900 flex items-center">
          <span class="text-gray-700 dark:text-gray-200">👤 Admin</span>
        </a>
        <a href="logoutvs.php" class="p-3 rounded hover:bg-red-100 dark:hover:bg-red-900 flex items-center">
          <span class="text-red-600 dark:text-red-400">🚪 Sair</span>
        </a>
      </nav>
    </aside>

    <!-- Caixa de Conteúdo -->
    <main class="flex-1 p-6 w-full"> 
      <div class="bg-white dark:bg-gray-800 rounded-xl shadow-md p-6">
        <h2 class="text-2xl font-semibold mb-4 text-gray-800 dark:text-gray-100">Painel de Gerenciamento DNS</h2>

        <?php
        // Incluindo o arquivo de configuração
        include 'config.php';

        // Variável para armazenar mensagem de notificação
        $notification = '';

        // Função para salvar as alterações no arquivo JSON
        function save_json($data) {
            global $json_file;
            file_put_contents($json_file, json_encode($data, JSON_PRETTY_PRINT));
        }

        // Carregar servidores do JSON
        $json = json_decode(file_get_contents($json_file), true);

        // Processando o envio do formulário para adicionar servidor
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_server'])) {
            $serverName = trim($_POST['server_name']);
            $serverAddress = trim($_POST['server_address']);
            if ($serverName && $serverAddress) {
                $newIndex = count($json) / 2 + 1; // Calcula o novo índice
                $json["server{$newIndex}_name"] = $serverName;
                $json["server{$newIndex}"] = $serverAddress;
                save_json($json);
                $notification = 'Servidor adicionado com sucesso!';
            } else {
                $notification = 'Por favor, preencha ambos os campos.';
            }
        }

        // Processando o envio do formulário para excluir servidor
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete_server'])) {
            $serverIndex = $_POST['delete_server'];
            unset($json[$serverIndex . '_name']);
            unset($json[$serverIndex]);
            save_json($json);
            $notification = 'Servidor excluído com sucesso!';
        }

        // Processando o envio do formulário para editar servidor
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['edit_server'])) {
            $serverIndex = $_POST['server_index'];
            $serverName = trim($_POST['edit_server_name']);
            $serverAddress = trim($_POST['edit_server_address']);
            if ($serverName && $serverAddress) {
                $json["{$serverIndex}_name"] = $serverName;
                $json[$serverIndex] = $serverAddress;
                save_json($json);
                $notification = 'Servidor editado com sucesso!';
            } else {
                $notification = 'Por favor, preencha ambos os campos.';
            }
        }
        ?>

        <?php if ($notification): ?>
            <div id="notification" class="notification show bg-green-200 text-green-800 p-4 rounded-lg mb-4" role="alert" aria-live="assertive"><?php echo htmlspecialchars($notification); ?></div>
        <?php endif; ?>

        <form method="post" action="" class="space-y-4">
            <div>
                <label for="server_name" class="block text-gray-600 dark:text-gray-300">Nome do Servidor:</label>
                <input type="text" id="server_name" name="server_name" placeholder="Ex: Google DNS" class="w-full p-2 border rounded dark:bg-gray-700 dark:text-gray-200" required />
            </div>
            <div>
                <label for="server_address" class="block text-gray-600 dark:text-gray-300">Endereço do Servidor:</label>
                <input type="text" id="server_address" name="server_address" placeholder="Ex: 8.8.8.8" class="w-full p-2 border rounded dark:bg-gray-700 dark:text-gray-200" required />
            </div>
            <button type="submit" name="add_server" aria-label="Adicionar Servidor" class="w-full bg-blue-600 text-white py-2 rounded hover:bg-blue-700 transition duration-200">Adicionar Servidor</button>
        </form>

        <h3 class="text-xl font-semibold mt-6 text-gray-800 dark:text-gray-100">Servidores Adicionados:</h3>
        <div class="overflow-x-auto">
          <table class="min-w-full bg-white dark:bg-gray-800 shadow rounded-lg">
            <thead>
              <tr class="w-full bg-gray-200 dark:bg-gray-700 text-gray-800 dark:text-gray-200">
                <th class="py-2 px-4 text-left">Nome</th>
                <th class="py-2 px-4 text-left">Endereço</th>
                <th class="py-2 px-4 text-left">Ações</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($json as $key => $value): ?>
                <?php if (strpos($key, '_name') !== false): ?>
                  <tr class="border-b border-gray-300 dark:border-gray-600">
                    <td class="py-2 px-4 text-gray-800 dark:text-gray-200"><?php echo htmlspecialchars($value); ?></td>
                    <td class="py-2 px-4 text-gray-800 dark:text-gray-200"><?php echo htmlspecialchars($json[str_replace('_name', '', $key)]); ?></td>
                    <td class="py-2 px-4">
                      <div class="flex space-x-2">
                        <button onclick="editServer('<?php echo str_replace('_name', '', $key); ?>', '<?php echo htmlspecialchars($value); ?>', '<?php echo htmlspecialchars($json[str_replace('_name', '', $key)]); ?>')" class="bg-blue-600 text-white action-button hover:bg-blue-700 transition duration-200">Editar</button>
                        <form method="post" action="" class="inline">
                          <input type="hidden" name="delete_server" value="<?php echo str_replace('_name', '', $key); ?>">
                          <button type="submit" class="bg-red-600 text-white action-button hover:bg-red-700 transition duration-200">Excluir</button>
                        </form>
                      </div>
                    </td>
                  </tr>
                <?php endif; ?>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>

        <!-- Overlay para fundo escurecido -->
        <div id="overlay" class="overlay" onclick="closeEditForm()"></div>

        <!-- Formulário de Edição -->
        <div id="editForm" class="bg-white dark:bg-gray-800 text-gray-800 dark:text-gray-200">
            <h4 class="text-xl font-semibold">Editar Servidor</h4>
            <form method="post" action="" class="space-y-4">
                <input type="hidden" id="server_index" name="server_index" />
                <div>
                    <label for="edit_server_name" class="block dark:text-gray-300">Nome do Servidor:</label>
                    <input type="text" id="edit_server_name" name="edit_server_name" class="w-full p-2 border rounded dark:bg-gray-700 dark:text-gray-200" required />
                </div>
                <div>
                    <label for="edit_server_address" class="block dark:text-gray-300">Endereço do Servidor:</label>
                    <input type="text" id="edit_server_address" name="edit_server_address" class="w-full p-2 border rounded dark:bg-gray-700 dark:text-gray-200" required />
                </div>
                <button type="submit" name="edit_server" class="w-full bg-blue-600 text-white py-2 rounded hover:bg-blue-700 transition duration-200">Salvar Alterações</button>
                <button type="button" onclick="closeEditForm()" class="w-full bg-gray-300 text-gray-800 py-2 rounded hover:bg-gray-400 transition duration-200">Cancelar</button>
            </form>
        </div>
      </div>
    </main>

  </div>

  <!-- Script para Dark Mode e Menu -->
  <script>
    const toggleDark = document.getElementById('toggleDark');
    const html = document.documentElement;

    // Dark mode persistente
    if (localStorage.getItem('theme') === 'dark') {
      html.classList.add('dark');
    }

    toggleDark.addEventListener('click', () => {
      if (html.classList.contains('dark')) {
        html.classList.remove('dark');
        localStorage.setItem('theme', 'light');
      } else {
        html.classList.add('dark');
        localStorage.setItem('theme', 'dark');
      }
    });

    // Controle do menu mobile
    const menuToggle = document.getElementById('menuToggle');
    const sidebar = document.getElementById('sidebar');

    menuToggle.addEventListener('click', () => {
      if (sidebar.classList.contains('-translate-x-full')) {
        sidebar.classList.remove('-translate-x-full');
      } else {
        sidebar.classList.add('-translate-x-full');
      }
    });

    // Função para ocultar a notificação após 5 segundos
    if (document.getElementById('notification')) {
      setTimeout(() => {
        const notification = document.getElementById('notification');
        notification.classList.add('hidden');
      }, 5000);
    }

    // Função para preencher e mostrar o formulário de edição
    function editServer(index, name, address) {
      document.getElementById('server_index').value = index;
      document.getElementById('edit_server_name').value = name;
      document.getElementById('edit_server_address').value = address;
      document.getElementById('editForm').style.display = 'block';
      document.getElementById('overlay').style.display = 'block'; // Exibir fundo escurecido
    }

    // Função para fechar o formulário de edição
    function closeEditForm() {
      document.getElementById('editForm').style.display = 'none';
      document.getElementById('overlay').style.display = 'none'; // Ocultar fundo escurecido
    }
  </script>

  <!-- Desativar clique direito e seleção de texto -->
  <body oncontextmenu="return false;">
    <style>
        body {
            -webkit-user-select: none; /* Safari */
            -moz-user-select: none; /* Firefox */
            -ms-user-select: none; /* Internet Explorer/Edge */
            user-select: none; /* Non-prefixed version */
        }
        
        /* Estilo para o fundo escurecido */
        .overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 900;
            display: none; /* Inicialmente oculto */
        }

        /* Estilo para o formulário flutuante */
        #editForm {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            border-radius: 8px;
            padding: 20px;
            z-index: 1000;
            display: none; /* Inicialmente oculto */
        }

        /* Estilo dos botões */
        .action-button {
            height: 40px; /* Altura do botão */
            width: 100px; /* Largura do botão */
            padding: 0 12px; /* Padding horizontal */
            border-radius: 4px; /* Arredondamento das bordas */
            display: flex; /* Flex para centralizar texto */
            align-items: center; /* Alinhamento vertical */
            justify-content: center; /* Centraliza o texto */
        }
    </style>

    <script>
        // Desativar a seleção de texto
        document.addEventListener('selectstart', function(e) {
            e.preventDefault();
        });
    </script>
  </body>
</html>