<?php
// Mostrar erros para depuração
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include "session.php";
include "config.php";
include "header.php";

// Função para obter dados da API via CURL
function getApiData($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36');
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5); // Timeout para evitar travamento
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    if (curl_errno($ch)) {
        curl_close($ch);
        return [];
    }
    curl_close($ch);
    if ($httpCode !== 200) {
        return [];
    }
    $data = json_decode($response, true);
    return is_array($data) ? $data : [];
}

// Obter o ID da série e a temporada selecionada
$id = isset($_GET['id']) ? (int)$_GET['id'] : null;
$selected_season = isset($_GET['season']) ? (int)$_GET['season'] : null;

if (!$id) {
    die("No se proporcionó ID de la serie.");
}

// Obter informações da série
$api_url = $get_dns . "/player_api.php?username=" . $username . "&password=" . $password . "&action=get_series_info&series_id=" . $id;
$series_data = getApiData($api_url);

if (!isset($series_data['info'])) {
    die("No se pudo obtener información de la serie.");
}

$series_info = $series_data['info'];
$title = $series_info['name'] ?? "Sem título";
$description = $series_info['plot'] ?? "Sem descrição";
$backdrop = $series_info['backdrop_path'][0] ?? "img/offvs.png";
$poster = $series_info['cover'] ?? "img/offvs.png";

// Obter temporadas e episódios
$seasons = isset($series_data['episodes']) ? $series_data['episodes'] : [];
if ($selected_season === null && !empty($seasons)) {
    reset($seasons);
    $selected_season = key($seasons);
}
$episodes = isset($seasons[$selected_season]) ? $seasons[$selected_season] : [];
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $sitename . ' - ' . $title; ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700&family=Roboto:wght@400;500;700&display=swap" rel="stylesheet" />
    <style>
        :root {
            --primary: #e50914;
            --secondary: #141414;
            --glass-bg: rgba(20,20,20,0.72);
            --glass-blur: 18px;
            --radius: 1.5rem;
            --shadow: 0 8px 32px 0 rgba(0,0,0,0.35);
            --white-glass: rgba(255,255,255,0.08);
        }
        html, body {
            margin: 0;
            padding: 0;
            background: linear-gradient(135deg, #1a1a1f 0%, #111115 100%);
            color: #fff;
            font-family: 'Montserrat', 'Roboto', Arial, sans-serif;
            min-height: 100vh;
            overflow-x: hidden;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
        }
        .featured-movie-container {
            position: relative;
            min-height: 54vh;
            background-image: url('<?php echo $backdrop; ?>');
            background-size: cover;
            background-position: center;
            display: flex;
            align-items: center;
            padding: 0 5vw;
            border-radius: var(--radius);
            margin: 2vw 2vw 0 2vw;
            overflow: hidden;
            box-shadow: var(--shadow);
        }
        .featured-movie-overlay {
            position: absolute;
            inset: 0;
            background: linear-gradient(90deg,rgba(18,18,24,0.96) 0%,rgba(18,18,24,0.85) 40%,rgba(18,18,24,0.35) 100%);
            z-index: 1;
        }
        .featured-movie-content {
            position: relative;
            z-index: 2;
            display: flex;
            align-items: flex-end;
            gap: 2.5vw;
            width: 100%;
            max-width: 1200px;
            margin: 0 auto;
        }
        .featured-movie-poster {
            flex: 0 0 180px;
            width: 180px;
            height: 270px;
            box-shadow: 0 8px 32px #000a;
            border-radius: 1.1rem;
            overflow: hidden;
            background: #222;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .featured-movie-poster img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 1.1rem;
            display: block;
        }
        .featured-movie-info {
            background: var(--glass-bg);
            backdrop-filter: blur(var(--glass-blur));
            border-radius: 1.1rem;
            box-shadow: 0 8px 38px 0 rgba(0,0,0,0.45);
            padding: 1.5rem 2rem;
            max-width: 520px;
            min-width: 0;
            margin-bottom: 2vw;
            border: 1.5px solid rgba(255,255,255,0.13);
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
        }
        .featured-movie-info .badge {
            display: inline-block;
            background: linear-gradient(90deg,#e50914 80%,#ffcc00 100%);
            color: #fff;
            font-size: 0.95rem;
            font-weight: bold;
            padding: 0.18em 0.9em;
            border-radius: 1em;
            letter-spacing: 1px;
            margin-bottom: 0.7em;
            box-shadow: 0 0 8px #e50914b0;
        }
        .featured-movie-info h2 {
            font-size: 1.45rem;
            margin-bottom: 0.3rem;
            font-weight: 800;
            letter-spacing: -1px;
            line-height: 1.1;
            color: #fff;
            text-shadow: 0 2px 8px #000a;
        }
        .featured-movie-info .movie-meta {
            margin-bottom: 0.5rem;
        }
        .featured-movie-info .rating {
            display: inline-block;
            background: #ffcc00;
            color: #222;
            font-size: 1.05rem;
            font-weight: 700;
            padding: 0.13em 0.7em;
            border-radius: 1em;
            margin-right: 0.7em;
            letter-spacing: 1px;
            box-shadow: 0 0 8px #ffcc0055;
        }
        .featured-movie-info p {
            font-size: 1rem;
            margin-bottom: 0.8rem;
            color: #e0e0e0;
            line-height: 1.4;
            text-shadow: 0 2px 8px #000a;
            max-height: 4.2em;
            overflow: hidden;
            min-height: 0;
            display: block;
            transition: max-height 0.3s;
        }
        .play-button {
            display: inline-flex;
            align-items: center;
            background: linear-gradient(90deg, #e50914 60%, #ff2a68 100%);
            color: #fff;
            padding: 0.7rem 1.5rem;
            font-size: 1rem;
            font-weight: bold;
            border: none;
            border-radius: 1.5rem;
            text-decoration: none;
            box-shadow: 0 0 10px 2px #e50914b0;
            transition: transform 0.14s, box-shadow 0.2s, background 0.3s;
            letter-spacing: 1px;
            cursor: pointer;
            outline: none;
            filter: drop-shadow(0 0 6px #e50914);
            text-transform: uppercase;
            gap: 0.5em;
        }
        .play-button svg {
            margin-right: 8px;
        }
        .play-button:hover, .play-button:focus {
            transform: scale(1.06);
            box-shadow: 0 0 18px 4px #e50914e0;
            background: linear-gradient(90deg, #ff2a68 0%, #e50914 100%);
        }
        .season-buttons {
            margin: 3vw 2vw 1vw 2vw;
            display: flex;
            flex-wrap: wrap;
            gap: 12px;
            justify-content: center;
        }
        .season-button {
            background: var(--glass-bg);
            color: #fff;
            padding: 0.5rem 1rem;
            border: none;
            border-radius: 1.2rem;
            font-size: 0.95rem;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.2s, box-shadow 0.2s, transform 0.18s;
            text-decoration: none;
        }
        .season-button:hover, .season-button.active {
            background: linear-gradient(90deg, #e50914 60%, #ff2a68 100%);
            box-shadow: 0 0 18px #e50914cc;
            transform: scale(1.05);
        }
        .episodes-carousel {
            display: flex;
            overflow-x: auto;
            gap: 14px;
            padding: 1vw 2vw 2vw 2vw;
            scroll-snap-type: x mandatory;
            scrollbar-width: none;
            -ms-overflow-style: none;
        }
        .episodes-carousel::-webkit-scrollbar {
            display: none;
        }
        .episode {
            background: #181818;
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.13);
            border: 1px solid rgba(255,255,255,0.10);
            width: 110px;
            min-width: 110px;
            max-width: 110px;
            display: flex;
            flex-direction: column;
            align-items: center;
            transition: transform 0.21s cubic-bezier(.4,0,.2,1), box-shadow 0.22s;
            cursor: pointer;
            scroll-snap-align: start;
            padding: 0 0 10px 0;
            position: relative;
            overflow: hidden;
        }
        .episode img {
            width: 100%;
            height: 160px;
            object-fit: cover;
            border-radius: 12px 12px 0 0;
            margin-bottom: 8px;
            box-shadow: 0 1px 5px rgba(0,0,0,0.18);
            transition: filter 0.18s;
            filter: brightness(0.96) saturate(1.1);
        }
        .episode p {
            text-align: center;
            margin: 0 4px 6px 4px;
            font-size: 0.82rem;
            color: #fff;
            font-weight: 500;
            min-height: 1.7em;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }
        .episode:hover {
            transform: scale(1.05) translateY(-4px);
            box-shadow: 0 0 14px 3px #e5091444, 0 4px 14px 0 rgba(0,0,0,0.18);
        }
        .episode:hover img {
            filter: brightness(1.04) saturate(1.2) blur(1px);
        }
        @media (max-width: 900px) {
            .featured-movie-content { flex-direction: column; align-items: flex-start; gap: 1.2rem; }
            .featured-movie-poster { width: 120px; height: 180px; flex-basis: 120px; }
            .featured-movie-info { padding: 1.1rem 1.2rem; max-width: 98vw; }
        }
        @media (max-width: 600px) {
            .featured-movie-container { min-height: 38vh; padding: 4vw 2vw; }
            .featured-movie-content { flex-direction: column; align-items: flex-start; gap: 1rem; }
            .featured-movie-poster { width: 90px; height: 135px; flex-basis: 90px; }
            .featured-movie-info h2 { font-size: 1.1rem; }
            .featured-movie-info p, .featured-movie-info .rating { font-size: 0.91rem; }
            .play-button { font-size: 0.91rem; padding: 0.6rem 1rem; }
            .episode { width: 90px; min-width: 90px; max-width: 90px; }
            .episode img { height: 120px; }
        }
    </style>
</head>
<body oncontextmenu="return false;">
    <script>
        document.addEventListener('selectstart', function(e) {
            e.preventDefault();
        });
    </script>
    <div class="featured-movie-container" id="featured-series-container">
        <div class="featured-movie-overlay"></div>
        <div class="featured-movie-content">
            <div class="featured-movie-poster">
                <img id="series-poster" src="<?php echo $poster; ?>" alt="<?php echo $title; ?>" />
            </div>
            <div class="featured-movie-info">
                <span class="badge">SÉRIE</span>
                <h2 id="series-title"><?php echo $title; ?></h2>
                <div class="movie-meta">
                    <span class="rating" id="series-rating"><?php echo $series_info['rating'] ?? 'N/A'; ?>/10</span>
                </div>
                <p id="series-description"><?php echo $description; ?></p>
                <a id="series-play-link" class="play-button" href="video_player?id=<?php echo $episodes[0]['id'] ?? '#'; ?>&slug=series&ext=<?php echo $episodes[0]['container_extension'] ?? 'mp4'; ?>&series_id=<?php echo $id; ?>">
                    <svg width="22" height="22" viewBox="0 0 24 24" fill="none" style="vertical-align: middle; margin-right:8px;">
                        <path d="M8 5v14l11-7z" fill="currentColor" />
                    </svg>
                    ASSISTIR AGORA
                </a>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="season-buttons">
            <?php foreach ($seasons as $season_number => $season_episodes): ?>
                <a href="?id=<?php echo $id; ?>&season=<?php echo $season_number; ?>" class="season-button <?php echo ($season_number == $selected_season) ? 'active' : ''; ?>">
                    Temporada <?php echo $season_number; ?>
                </a>
            <?php endforeach; ?>
        </div>

        <div class="episodes-carousel">
            <?php
            $max_episodes = 10; // Limitar para evitar sobrecarga
            $episode_count = 0;
            foreach ($episodes as $episode):
                if ($episode_count >= $max_episodes) break;
                $episode_title = $episode['title'] ?? "Episódio sem título";
                $episode_image = $episode['info']['movie_image'] ?? "img/offvs.png";
                $play_url = "video_player?id=" . ($episode['id'] ?? 0) . "&slug=series&ext=" . ($episode['container_extension'] ?? 'mp4') . "&series_id=" . $id;
            ?>
                <div class="episode">
                    <a href="<?php echo $play_url; ?>">
                        <img src="<?php echo $episode_image; ?>" alt="<?php echo $episode_title; ?>">
                        <p><?php echo $episode_title; ?></p>
                    </a>
                </div>
            <?php
                $episode_count++;
            endforeach;
            ?>
        </div>
    </div>

    <script>
        // Função de debounce para otimizar eventos
        function debounce(func, wait) {
            let timeout;
            return function executedFunction(...args) {
                const later = () => {
                    clearTimeout(timeout);
                    func(...args);
                };
                clearTimeout(timeout);
                timeout = setTimeout(later, wait);
            };
        }

        // Carregar episódios apenas quando necessário
        document.addEventListener('DOMContentLoaded', function() {
            const carousel = document.querySelector('.episodes-carousel');
            if (carousel.children.length === 0) {
                console.warn("Nenhum episódio disponível para a temporada selecionada.");
            }
        });
    </script>
</body>
</html>