<body oncontextmenu="return false;"> <!-- Desativa o clique direito -->
    <style>
        body {
            -webkit-user-select: none; /* Safari */
            -moz-user-select: none; /* Firefox */
            -ms-user-select: none; /* Internet Explorer/Edge */
            user-select: none; /* Non-prefixed version */
        }
    </style>

    <script>
        // Desativar a seleção de texto
        document.addEventListener('selectstart', function(e) {
            e.preventDefault();
        });
    </script>
</body>

<?php
session_start();

// Função para carregar as configurações do arquivo JSON
function loadConfig() {
    return json_decode(file_get_contents('config.json'), true);
}

// Carregar configurações
$config = loadConfig();

// Processo de autenticação do usuário
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["username"]) && isset($_POST["password"])) {
    $username = $_POST["username"];
    $password = $_POST["password"];

    // Verifica se as credenciais estão corretas
    if ($username === $config['usuario'] && $password === $config['senha']) {
        $_SESSION["username"] = $username;
        header('Location: dashboard.php'); // Redireciona para o dashboard
        exit;
    } else {
        $error_message = 'Usuário ou senha inválidos!';
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Painel de Login</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;700&family=Orbitron:wght@700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #00ffe7;         /* Azul neon para destaques */
            --secondary: #23233a;       /* Cinza escuro para bordas */
            --background: #0a0a15;      /* Fundo escuro */
            --glass-bg: rgba(30, 30, 40, 0.80);
            --glass-blur: blur(18px) saturate(170%);
            --input-bg: #181826;        /* Fundo dos campos */
            --input-border: #23233a;    /* Borda dos campos */
            --radius: 32px;
            --shadow: 0 8px 32px 0 rgba(0,0,0,0.45);
            --ticket: repeating-linear-gradient(90deg, #fff2 0 5px, transparent 5px 10px);
        }
        html, body {
            height: 100%;
            margin: 0;
            padding: 0;
        }
        body {
            min-height: 100vh;
            background: var(--background);
            font-family: 'Inter', Arial, sans-serif;
            color: #fff;
            overflow: hidden;
            position: relative;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        /* Animação de partículas (estrelas/cinema) */
        #particles {
            position: fixed;
            inset: 0;
            z-index: 0;
            pointer-events: none;
        }
        .login-container {
            position: relative;
            z-index: 1;
            background: var(--glass-bg);
            backdrop-filter: var(--glass-blur);
            -webkit-backdrop-filter: var(--glass-blur);
            box-shadow: var(--shadow);
            border-radius: var(--radius);
            padding: 56px 48px 40px 48px;
            width: 400px;
            max-width: 97vw;
            text-align: center;
            border: 2px solid rgba(255,255,255,0.09);
            margin: 0 auto;
            animation: fadeIn 1.1s cubic-bezier(.77,0,.18,1);
            box-sizing: border-box;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(40px);}
            to   { opacity: 1; transform: translateY(0);}
        }
        .logo {
            width: 120px;
            margin-bottom: 18px;
            border-radius: 16px;
            background: rgba(255,255,255,0.03);
            padding: 4px;
            box-shadow: 0 2px 18px 0 #00ffe755;
            transition: box-shadow 0.3s;
        }
        .login-title {
            font-family: 'Orbitron', 'Inter', Arial, sans-serif;
            font-size: 2.1rem;
            letter-spacing: 2.5px;
            font-weight: 700;
            margin-bottom: 8px;
            color: var(--primary);
            text-shadow: 0 2px 12px #00ffe755, 0 0 2px #fff;
            background: var(--ticket);
            background-clip: text;
            -webkit-background-clip: text;
        }
        .login-sub {
            font-size: 1.1rem;
            color: #fff8;
            margin-bottom: 24px;
            font-weight: 400;
            letter-spacing: 0.6px;
        }
        .error {
            color: #fff;
            background: #23233a;
            border-radius: 12px;
            padding: 12px 0;
            margin-bottom: 18px;
            font-weight: 600;
            font-size: 1.07rem;
            letter-spacing: 0.8px;
            box-shadow: 0 2px 12px #0005;
            border: 1.5px solid #23233a;
            animation: shake .22s 2;
        }
        @keyframes shake {
            0% { transform: translateX(0);}
            25% { transform: translateX(-6px);}
            50% { transform: translateX(6px);}
            75% { transform: translateX(-3px);}
            100% { transform: translateX(0);}
        }
        form {
            display: flex;
            flex-direction: column;
            gap: 20px;
        }
        input[type="text"], input[type="password"] {
            background: var(--input-bg);
            border: 2px solid var(--input-border);
            border-radius: 16px;
            padding: 16px 18px;
            color: #fff;
            font-size: 1.13rem;
            font-family: inherit;
            outline: none;
            transition: border 0.2s, background 0.2s, box-shadow 0.2s;
            box-shadow: 0 1px 8px 0 #0002;
            font-weight: 500;
            letter-spacing: 0.2px;
        }
        input[type="text"]:focus, input[type="password"]:focus {
            border: 2px solid var(--primary);
            background: #23233a;
            box-shadow: 0 0 0 2px #00ffe733, 0 1px 10px 0 #00ffe755;
        }
        button[type="submit"] {
            background: linear-gradient(90deg, #23233a 60%, #181826 100%);
            color: #fff;
            border: none;
            border-radius: 16px;
            padding: 16px 0;
            font-size: 1.16rem;
            font-weight: 700;
            letter-spacing: 1.5px;
            box-shadow: 0 0 18px 0 #00ffe755, 0 2px 18px 0 #23233a88;
            cursor: pointer;
            transition: background 0.22s, transform 0.18s, box-shadow 0.18s;
            position: relative;
            overflow: hidden;
            outline: none;
            filter: brightness(1.08);
        }
        button[type="submit"]:hover, button[type="submit"]:focus {
            background: linear-gradient(90deg, #181826 0%, #23233a 100%);
            transform: translateY(-2px) scale(1.04);
            box-shadow: 0 0 0 6px #00ffe733, 0 0 32px 0 #00ffe755;
        }
        button[type="submit"]::before {
            content: "";
            position: absolute;
            left: 50%;
            top: 0;
            width: 0;
            height: 100%;
            background: radial-gradient(ellipse at center, #fff8 0%, #fff0 80%);
            opacity: 0.23;
            transform: translateX(-50%);
            transition: width 0.4s;
            z-index: 1;
        }
        button[type="submit"]:hover::before {
            width: 120%;
        }
        @media (max-width: 540px) {
            .login-container {
                padding: 28px 4vw 18px 4vw;
                width: 99vw;
            }
            .login-title { font-size: 1.3rem; }
            .logo { width: 70px; }
        }
        @media (max-width: 370px) {
            .login-container {
                padding: 14px 2vw 10px 2vw;
            }
        }
    </style>
</head>
<body>
    <canvas id="particles"></canvas>
    <div class="login-container">
        <img src="<?php echo htmlspecialchars($config['logo']); ?>" alt="Logo" class="logo">
        <div class="login-title">ENTRADA VIP</div>
        <div class="login-sub">Acesso exclusivo somente para Administradores</div>
        <?php if (isset($error_message)) { echo '<p class="error">' . htmlspecialchars($error_message) . '</p>'; } ?>
        <form method="post" action="">
            <input type="text" name="username" placeholder="Usuário" required autocomplete="username">
            <input type="password" name="password" placeholder="Senha" required autocomplete="current-password">
            <button type="submit">Entrar</button>
        </form>
    </div>
    <script>
    // Partículas de estrelas/cinema
    const canvas = document.getElementById('particles');
    const ctx = canvas.getContext('2d');
    let w = window.innerWidth, h = window.innerHeight;
    canvas.width = w; canvas.height = h;

    function resize() {
        w = window.innerWidth; h = window.innerHeight;
        canvas.width = w; canvas.height = h;
    }
    window.addEventListener('resize', resize);

    // Gera partículas (estrelas e "flares" de projetor)
    const particles = [];
    const STAR = 0, FLARE = 1;
    for(let i=0;i<60;i++) {
        let t = Math.random() < 0.85 ? STAR : FLARE;
        particles.push({
            x: Math.random()*w,
            y: Math.random()*h,
            r: t===STAR ? Math.random()*1.2+0.5 : Math.random()*8+4,
            s: t===STAR ? Math.random()*0.3+0.1 : Math.random()*0.2+0.05,
            o: t===STAR ? Math.random()*0.4+0.3 : Math.random()*0.17+0.07,
            t: t,
            dx: (Math.random()-0.5)*0.12,
            dy: (Math.random()-0.5)*0.12
        });
    }
    function draw() {
        ctx.clearRect(0,0,w,h);
        for(let p of particles) {
            ctx.save();
            if(p.t===STAR) {
                ctx.globalAlpha = p.o * (0.7 + 0.3*Math.sin(Date.now()/400+p.x));
                ctx.beginPath();
                ctx.arc(p.x, p.y, p.r, 0, Math.PI*2);
                ctx.fillStyle = "#fff";
                ctx.shadowColor = "#fff";
                ctx.shadowBlur = 8;
                ctx.fill();
            } else { // FLARE
                ctx.globalAlpha = p.o * (0.6 + 0.4*Math.cos(Date.now()/900+p.y));
                let grad = ctx.createRadialGradient(p.x, p.y, 0, p.x, p.y, p.r);
                grad.addColorStop(0, "#fff");
                grad.addColorStop(0.2, "#00ffe7cc");
                grad.addColorStop(1, "#0000");
                ctx.beginPath();
                ctx.arc(p.x, p.y, p.r, 0, Math.PI*2);
                ctx.fillStyle = grad;
                ctx.fill();
            }
            ctx.restore();
            // Movimento sutil
            p.x += p.dx;
            p.y += p.dy;
            if(p.x<0) p.x=w; if(p.x>w) p.x=0;
            if(p.y<0) p.y=h; if(p.y>h) p.y=0;
        }
        requestAnimationFrame(draw);
    }
    draw();
    </script>
</body>
</html>
