<?php
session_start();

// Include config file
require_once('config.php');

// Carregar configuração
$config = json_decode(file_get_contents('config.json'), true) ?? [];

// Load DNS configuration
$dns_data = json_decode(file_get_contents("./includes/dns/dns.json"), true) ?? [];
$available_servers = [];

// Collect available servers
for ($i = 1; $i <= 1000; $i++) {
    if (!empty($dns_data["server{$i}"]) && !empty($dns_data["server{$i}_name"])) {
        $available_servers[] = [
            'name' => $dns_data["server{$i}_name"],
            'url' => $dns_data["server{$i}"]
        ];
    }
}

// Processo de autenticação do usuário
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["username"]) && isset($_POST["password"])) {
    $username = $_POST["username"];
    $password = $_POST["password"];

    $auth_success = false;
    $error_message = '';

    foreach ($available_servers as $server) {
        $server_url = $server['url'];
        $authUrl = rtrim($server_url, '/') . "/player_api.php?username={$username}&password={$password}";
        $userAgent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36';
        $opts = [
            'http' => [
                'header' => "User-Agent: $userAgent\r\n"
            ]
        ];
        $context = stream_context_create($opts);

        $response = @file_get_contents($authUrl, false, $context);
        if ($response === FALSE) {
            $error_message = 'Erro de conexão com o servidor: ' . htmlspecialchars($server['name']);
            continue; // Tentar o próximo servidor se houver erro
        }
        
        $api = json_decode($response, true);
        if (isset($api['user_info']['auth']) && $api['user_info']['auth'] == 1 && $api['user_info']['status'] === "Active") {
            $_SESSION["username"] = $username;
            $_SESSION["password"] = $password;
            $_SESSION["server_url"] = $server_url;

            $auth_success = true;
            echo json_encode(['success' => true, 'redirect' => 'homex']);
            break; // Saia do loop se a autenticação for bem-sucedida
        } else {
            $error_message = 'Credenciais incorretas ou conta inativa para ' . htmlspecialchars($server['name']);
        }
    }

    if (!$auth_success) {
        echo json_encode(['success' => false, 'message' => $error_message]);
    }
    exit;
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="theme-color" content="#0a0a0f">
    <title>WebPlay - MidiaDigitalvs</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&family=JetBrains+Mono:wght@400;500&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --secondary-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            --accent-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            --dark-gradient: linear-gradient(135deg, #0c0c0c 0%, #1a1a2e 50%, #16213e 100%);
            --glass-bg: rgba(255, 255, 255, 0.03);
            --glass-border: rgba(255, 255, 255, 0.08);
            --text-primary: #ffffff;
            --text-secondary: rgba(255, 255, 255, 0.7);
            --text-accent: #60a5fa;
            --error-color: #ef4444;
            --success-color: #10b981;
            --shadow-primary: 0 25px 50px -12px rgba(0, 0, 0, 0.4);
            --shadow-glow: 0 0 60px rgba(102, 126, 234, 0.2);
            --border-radius: 20px;
            --border-radius-lg: 28px;
            --transition: all 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body, html {
            height: 100%;
            font-family: 'Space Grotesk', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: var(--dark-gradient);
            color: var(--text-primary);
            overflow-x: hidden;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }

        /* Animated Background */
        .animated-bg {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1;
            overflow: hidden;
        }

        .bg-orbs {
            position: absolute;
            width: 100%;
            height: 100%;
        }

        .orb {
            position: absolute;
            border-radius: 50%;
            filter: blur(60px);
            opacity: 0.1;
            animation: float 20s ease-in-out infinite;
        }

        .orb:nth-child(1) {
            width: 400px;
            height: 400px;
            background: var(--primary-gradient);
            top: 10%;
            left: 10%;
            animation-delay: 0s;
        }

        .orb:nth-child(2) {
            width: 300px;
            height: 300px;
            background: var(--secondary-gradient);
            top: 60%;
            right: 10%;
            animation-delay: -5s;
        }

        .orb:nth-child(3) {
            width: 500px;
            height: 500px;
            background: var(--accent-gradient);
            bottom: 10%;
            left: 50%;
            transform: translateX(-50%);
            animation-delay: -10s;
        }

        @keyframes float {
            0%, 100% { 
                transform: translateY(0px) scale(1);
                opacity: 0.1;
            }
            25% { 
                transform: translateY(-30px) scale(1.1);
                opacity: 0.15;
            }
            50% { 
                transform: translateY(-20px) scale(0.9);
                opacity: 0.08;
            }
            75% { 
                transform: translateY(-40px) scale(1.05);
                opacity: 0.12;
            }
        }

        /* Futuristic Login Interface */
        .login-stage {
            position: relative;
            z-index: 100;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            perspective: 1000px;
        }

        .login-portal {
            background: var(--glass-bg);
            backdrop-filter: blur(40px) saturate(180%);
            border: 2px solid var(--glass-border);
            border-radius: var(--border-radius-lg);
            padding: 60px 50px;
            width: 480px;
            max-width: 90vw;
            position: relative;
            overflow: hidden;
            box-shadow: 
                var(--shadow-primary),
                var(--shadow-glow),
                inset 0 1px 0 rgba(255, 255, 255, 0.1);
            transform-style: preserve-3d;
            animation: portalEntry 1s ease-out;
        }

        @keyframes portalEntry {
            0% {
                opacity: 0;
                transform: scale(0.8) rotateX(10deg);
            }
            100% {
                opacity: 1;
                transform: scale(1) rotateX(0deg);
            }
        }

        .login-portal::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 2px;
            background: var(--primary-gradient);
            animation: energyPulse 3s ease-in-out infinite;
        }

        .login-portal::after {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: conic-gradient(from 0deg, transparent, rgba(102, 126, 234, 0.03), transparent);
            animation: rotate 10s linear infinite;
            pointer-events: none;
        }

        @keyframes energyPulse {
            0%, 100% { opacity: 0.3; transform: scaleX(1); }
            50% { opacity: 1; transform: scaleX(1.1); }
        }

        @keyframes rotate {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Logo Section */
        .brand-showcase {
            text-align: center;
            margin-bottom: 40px;
            position: relative;
        }

        .brand-showcase img {
            max-width: 220px;
            height: auto;
            filter: brightness(1.2) saturate(1.1) drop-shadow(0 10px 30px rgba(102, 126, 234, 0.3));
            transition: var(--transition);
            animation: logoGlow 4s ease-in-out infinite alternate;
        }

        @keyframes logoGlow {
            0% { filter: brightness(1.2) saturate(1.1) drop-shadow(0 10px 30px rgba(102, 126, 234, 0.3)); }
            100% { filter: brightness(1.4) saturate(1.3) drop-shadow(0 15px 40px rgba(102, 126, 234, 0.5)); }
        }

        /* Welcome Section */
        .welcome-header {
            text-align: center;
            margin-bottom: 40px;
        }

        .welcome-title {
            font-size: clamp(28px, 5vw, 40px);
            font-weight: 700;
            background: linear-gradient(135deg, #ffffff 0%, #e0e0e0 50%, #60a5fa 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 12px;
            letter-spacing: -1px;
            animation: titleShimmer 3s ease-in-out infinite;
        }

        @keyframes titleShimmer {
            0%, 100% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
        }

        .welcome-subtitle {
            color: var(--text-secondary);
            font-size: 18px;
            font-weight: 400;
            letter-spacing: 0.5px;
        }

        /* Futuristic Form */
        .quantum-form {
            position: relative;
        }

        .input-field {
            position: relative;
            margin-bottom: 28px;
        }

        .field-input {
            width: 100%;
            padding: 20px 24px 20px 60px;
            background: rgba(255, 255, 255, 0.04);
            border: 2px solid rgba(255, 255, 255, 0.08);
            border-radius: 16px;
            color: var(--text-primary);
            font-size: 16px;
            font-weight: 500;
            font-family: 'JetBrains Mono', monospace;
            transition: var(--transition);
            backdrop-filter: blur(20px);
            position: relative;
            z-index: 1;
        }

        .field-input:focus {
            outline: none;
            background: rgba(255, 255, 255, 0.08);
            border-color: #4facfe;
            box-shadow: 
                0 0 0 4px rgba(79, 172, 254, 0.1),
                0 10px 40px rgba(79, 172, 254, 0.2);
            transform: translateY(-2px);
        }

        .field-input::placeholder {
            color: rgba(255, 255, 255, 0.4);
            font-weight: 400;
        }

        .field-icon {
            position: absolute;
            left: 22px;
            top: 50%;
            transform: translateY(-50%);
            color: rgba(255, 255, 255, 0.5);
            font-size: 20px;
            transition: var(--transition);
            z-index: 2;
        }

        .field-input:focus + .field-icon {
            color: #4facfe;
            transform: translateY(-50%) scale(1.1);
        }

        /* Animated scanning line */
        .field-input:focus::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 2px;
            background: linear-gradient(90deg, transparent, #4facfe, transparent);
            animation: scan 2s ease-in-out infinite;
        }

        @keyframes scan {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(100%); }
        }

        /* Quantum Button */
        .quantum-button {
            width: 100%;
            padding: 20px;
            background: var(--primary-gradient);
            border: none;
            border-radius: 16px;
            color: white;
            font-size: 18px;
            font-weight: 600;
            font-family: 'Space Grotesk', sans-serif;
            cursor: pointer;
            position: relative;
            overflow: hidden;
            margin-top: 16px;
            transition: var(--transition);
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .quantum-button::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transition: left 0.8s ease;
        }

        .quantum-button:hover::before {
            left: 100%;
        }

        .quantum-button:hover {
            background: linear-gradient(135deg, #5a6cf0, #8b5fbf);
            transform: translateY(-3px);
            box-shadow: 
                0 20px 40px rgba(102, 126, 234, 0.4),
                0 0 60px rgba(102, 126, 234, 0.2);
        }

        .quantum-button:active {
            transform: translateY(-1px);
        }

        .quantum-button.loading {
            background: linear-gradient(135deg, #6b7280, #4b5563);
            cursor: not-allowed;
            transform: none;
        }

        .button-content {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
        }

        .cyber-spinner {
            width: 24px;
            height: 24px;
            border: 3px solid transparent;
            border-top: 3px solid white;
            border-radius: 50%;
            animation: cyberSpin 1s linear infinite;
            display: none;
        }

        @keyframes cyberSpin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Error Display */
        .error-portal {
            background: rgba(239, 68, 68, 0.1);
            border: 2px solid rgba(239, 68, 68, 0.3);
            border-radius: 12px;
            padding: 16px 20px;
            color: #fca5a5;
            font-size: 14px;
            font-weight: 500;
            margin-top: 20px;
            display: none;
            animation: errorSlide 0.4s ease-out;
            backdrop-filter: blur(10px);
        }

        @keyframes errorSlide {
            0% {
                opacity: 0;
                transform: translateY(-20px) scale(0.95);
            }
            100% {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }

        /* Futuristic Footer */
        .cyber-footer {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            background: rgba(0, 0, 0, 0.4);
            backdrop-filter: blur(30px) saturate(150%);
            border-top: 1px solid rgba(255, 255, 255, 0.08);
            color: var(--text-secondary);
            text-align: center;
            padding: 20px;
            z-index: 1000;
            font-size: 14px;
            font-weight: 500;
        }

        .cyber-footer a {
            color: var(--text-accent);
            text-decoration: none;
            font-weight: 600;
            transition: var(--transition);
            position: relative;
        }

        .cyber-footer a::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 0;
            height: 2px;
            background: var(--accent-gradient);
            transition: width 0.3s ease;
        }

        .cyber-footer a:hover::after {
            width: 100%;
        }

        .cyber-footer a:hover {
            color: #60a5fa;
            text-shadow: 0 0 10px rgba(96, 165, 250, 0.5);
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .login-portal {
                padding: 40px 30px;
                margin: 20px;
                border-radius: var(--border-radius);
            }

            .welcome-title {
                font-size: 32px;
            }

            .welcome-subtitle {
                font-size: 16px;
            }

            .field-input {
                padding: 18px 22px 18px 55px;
                font-size: 15px;
            }

            .quantum-button {
                padding: 18px;
                font-size: 16px;
            }
        }

        @media (max-width: 480px) {
            .login-portal {
                padding: 30px 20px;
            }

            .welcome-title {
                font-size: 28px;
            }

            .field-input {
                padding: 16px 20px 16px 50px;
            }

            .quantum-button {
                padding: 16px;
                font-size: 15px;
            }
        }

        /* Accessibility */
        @media (prefers-reduced-motion: reduce) {
            .orb,
            .login-portal::after {
                animation: none;
            }
            
            .field-input,
            .quantum-button {
                transition: none;
            }
        }

        @media (prefers-contrast: high) {
            .login-portal {
                background: rgba(0, 0, 0, 0.9);
                border: 3px solid #ffffff;
            }
            
            .field-input {
                background: rgba(0, 0, 0, 0.8);
                border: 2px solid #ffffff;
            }
        }

        /* Custom Scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
        }

        ::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.05);
        }

        ::-webkit-scrollbar-thumb {
            background: var(--primary-gradient);
            border-radius: 4px;
        }
    </style>
</head>
<body>
    <!-- Animated Background -->
    <div class="animated-bg">
        <div class="bg-orbs">
            <div class="orb"></div>
            <div class="orb"></div>
            <div class="orb"></div>
        </div>
    </div>

    <!-- Login Interface -->
    <div class="login-stage">
        <div class="login-portal">
            <div class="brand-showcase">
                <img src="<?php echo htmlspecialchars($config['logo'] ?? 'default-logo.png'); ?>" alt="WebPlay" id="brand-logo">
            </div>
            
            <div class="welcome-header">
                <h1 class="welcome-title">Acesso Autorizado</h1>
                <p class="welcome-subtitle">Conecte-se ao futuro do entretenimento</p>
            </div>

            <form id="quantum-form" class="quantum-form" method="POST">
                <div class="input-field">
                    <input type="text" class="field-input" placeholder="ID de Usuário" name="username" required autocomplete="username" spellcheck="false">
                    <i class="fas fa-user-astronaut field-icon"></i>
                </div>

                <div class="input-field">
                    <input type="password" class="field-input" placeholder="Código de Acesso" name="password" required autocomplete="current-password">
                    <i class="fas fa-lock field-icon"></i>
                </div>

                <button type="submit" class="quantum-button" id="access-button">
                    <div class="button-content">
                        <span class="button-text">Iniciar Conexão</span>
                        <i class="fas fa-rocket" id="button-icon"></i>
                    </div>
                </button>

                <div class="error-portal" id="error-display"></div>
            </form>
        </div>
    </div>

    <!-- Cyber Footer -->
    <div class="cyber-footer">
        <p>© 2025 <a href="https://midiadigitalvs.com.br" target="_blank" rel="noopener">Powered by Midia Digitalvs</a> • Web Player 2025</p>
    </div>

    <script>
    document.getElementById('quantum-form').addEventListener('submit', async function(event) {
        event.preventDefault();
        
        const formData = new FormData(this);
        const response = await fetch('', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        });
        const data = await response.json();

        const errorDisplay = document.getElementById('error-display');
        if (data.success) {
            window.location.href = data.redirect;
        } else {
            errorDisplay.textContent = data.message;
            errorDisplay.style.display = 'block';
        }
    });
    </script>
</body>
</html>