<?php
// Iniciar sessão para verificar autenticação (opcional, se aplicável)
session_start();

// Verificar se o usuário está autenticado (opcional, ajuste conforme necessário)
if (!isset($_SESSION["username"])) {
    // Redirecionar para a página de login ou exibir uma mensagem
    header("Location: ../login.php");
    exit;
}

// Configurações de estilo minimalista com tema futurista
header("Content-Type: text/html; charset=utf-8");
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow"> <!-- Impedir indexação por motores de busca -->
    <title>Acesso Restrito</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            background: linear-gradient(135deg, #0c0c0c 0%, #1a1a2e 50%, #16213e 100%);
            color: #ffffff;
            font-family: 'Arial', sans-serif;
            overflow: hidden;
        }
        .container {
            text-align: center;
            padding: 20px;
            border-radius: 10px;
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            box-shadow: 0 0 20px rgba(102, 126, 234, 0.2);
        }
        .message {
            font-size: 18px;
            color: rgba(255, 255, 255, 0.7);
        }
        .icon {
            font-size: 40px;
            color: #667eea;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="icon">🔒</div>
        <div class="message">Acesso restrito. Esta pasta está protegida.</div>
    </div>
</body>
</html>