<?php
session_start();

// Verifica se o usuário está autenticado
if (!isset($_SESSION["username"])) {
    header('Location: painel.php'); // Redireciona para o painel de login
    exit;
}

// Incluindo o arquivo de configuração
include 'config.php';

// Carregando servidores do arquivo JSON
$json_file = './includes/dns/dns.json'; // Caminho definido no config.php
$json = json_decode(file_get_contents($json_file), true) ?? [];

// Definindo a quantidade total de servidores
$quantidadeServidores = 6;
$servidoresEmUso = 0;

// Contando servidores em uso com base nos pares serverX_name e serverX
for ($i = 1; $i <= $quantidadeServidores; $i++) {
    $server_name = "server{$i}_name";
    $server_url = "server{$i}";
    if (!empty($json[$server_name]) || !empty($json[$server_url])) {
        $servidoresEmUso++;
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Painel Responsivo com Dark Mode</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    tailwind.config = {
      darkMode: 'class'
    }
  </script>
</head>
<body oncontextmenu="return false;" class="bg-gray-100 dark:bg-gray-900">
  <style>
    body {
      -webkit-user-select: none; /* Safari */
      -moz-user-select: none; /* Firefox */
      -ms-user-select: none; /* Internet Explorer/Edge */
      user-select: none; /* Non-prefixed version */
    }
  </style>

  <script>
    // Desativar a seleção de texto
    document.addEventListener('selectstart', function(e) {
      e.preventDefault();
    });
  </script>

  <!-- Cabeçalho -->
  <header class="w-full h-16 bg-white dark:bg-gray-800 shadow flex items-center justify-between px-6">
    <div class="flex items-center gap-4">
      <button id="menuToggle" class="block md:hidden text-2xl text-gray-700 dark:text-gray-200">☰</button>
      <div class="text-2xl font-bold text-gray-700 dark:text-gray-100">Web Player 2025</div>
    </div>

    <div class="flex items-center gap-4">
      <button id="toggleDark" class="px-4 py-2 bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-200 rounded hover:bg-gray-300 dark:hover:bg-gray-600">🌙/☀</button>
      <div class="text-gray-500 dark:text-gray-300 hidden sm:block">Bem-vindo, Usuário</div>
    </div>
  </header>

  <div class="flex">

    <!-- Menu Lateral -->
    <aside id="sidebar" class="w-64 bg-white dark:bg-gray-800 h-[calc(100vh-4rem)] shadow-md fixed md:static top-16 left-0 transform -translate-x-full md:translate-x-0 transition-transform duration-300 z-50">
      <nav class="flex flex-col p-4 space-y-2">
        <a href="dashboard.php" class="p-3 rounded hover:bg-blue-100 dark:hover:bg-blue-900 flex items-center">
          <span class="text-gray-700 dark:text-gray-200">🏠 Dashboard</span>
        </a>
        <a href="servidores.php" class="p-3 rounded hover:bg-blue-100 dark:hover:bg-blue-900 flex items-center">
          <span class="text-gray-700 dark:text-gray-200">🖥 Servidores</span>
        </a>
        <a href="admin.php" class="p-3 rounded hover:bg-blue-100 dark:hover:bg-blue-900 flex items-center">
          <span class="text-gray-700 dark:text-gray-200">👤 Admin</span>
        </a>
        <a href="logoutvs.php" class="p-3 rounded hover:bg-red-100 dark:hover:bg-red-900 flex items-center">
          <span class="text-red-600 dark:text-red-400">🚪 Sair</span>
        </a>
      </nav>
    </aside>

    <!-- Caixa de Conteúdo -->
    <main class="flex-1 p-6 w-full"> 
      <div class="bg-white dark:bg-gray-800 rounded-xl shadow-md p-6">
        <h2 class="text-2xl font-semibold mb-4 text-gray-800 dark:text-gray-100">Ação Rapida</h2>

        <!-- Cards com informações -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
          <!-- Card: Quantidade de Servidores -->
          <a href="servidores.php" class="bg-blue-500 text-white rounded-lg p-6 shadow-md transition-transform transform hover:scale-105">
            <h3 class="text-lg font-semibold">Servidores</h3>
            <p class="text-2xl"><?php echo $servidoresEmUso . '/' . $quantidadeServidores; ?></p> <!-- Exibe 1/6 -->
          </a>

          <!-- Card: Servidores em Uso -->
          <a href="login.php" class="bg-green-500 text-white rounded-lg p-6 shadow-md transition-transform transform hover:scale-105">
            <h3 class="text-lg font-semibold">Player</h3>
            <p class="text-2xl">▶</p> <!-- Ícone de Player de Vídeo -->
          </a>

          <!-- Card: Quantidade de Admins -->
          <a href="admin.php" class="bg-yellow-500 text-white rounded-lg p-6 shadow-md transition-transform transform hover:scale-105">
            <h3 class="text-lg font-semibold">Admin</h3>
            <p class="text-2xl">👨‍💼</p> <!-- Ícone de Admin -->
          </a>
        </div>

      </div>
    </main>

  </div>

  <!-- Script para Dark Mode e Menu -->
  <script>
    const toggleDark = document.getElementById('toggleDark');
    const html = document.documentElement;

    // Dark mode persistente
    if (localStorage.getItem('theme') === 'dark') {
      html.classList.add('dark');
    }

    toggleDark.addEventListener('click', () => {
      if (html.classList.contains('dark')) {
        html.classList.remove('dark');
        localStorage.setItem('theme', 'light');
      } else {
        html.classList.add('dark');
        localStorage.setItem('theme', 'dark');
      }
    });

    // Controle do menu mobile
    const menuToggle = document.getElementById('menuToggle');
    const sidebar = document.getElementById('sidebar');

    menuToggle.addEventListener('click', () => {
      if (sidebar.classList.contains('-translate-x-full')) {
        sidebar.classList.remove('-translate-x-full');
      } else {
        sidebar.classList.add('-translate-x-full');
      }
    });
  </script>

</body>
</html>