
<body oncontextmenu="return false;"> <!-- Desativa o clique direito -->
    <style>
        body {
            -webkit-user-select: none; /* Safari */
            -moz-user-select: none; /* Firefox */
            -ms-user-select: none; /* Internet Explorer/Edge */
            user-select: none; /* Non-prefixed version */
        }
    </style>

    <script>
        // Desativar a seleção de texto
        document.addEventListener('selectstart', function(e) {
            e.preventDefault();
        });
    </script>
</body>

<?php
session_start();

// Verifica se o usuário está autenticado
if (!isset($_SESSION["username"])) {
    header('Location: painel.php'); // Redireciona para o painel de login
    exit;
}

// Função para carregar as configurações do arquivo JSON
function loadConfig() {
    return json_decode(file_get_contents('config.json'), true);
}

// Função para salvar as configurações no arquivo JSON
function saveConfig($config) {
    file_put_contents('config.json', json_encode($config, JSON_PRETTY_PRINT));
}

// Carregar configurações
$config = loadConfig();

// Verifique se há mensagem de sucesso na sessão
$success_message = isset($_SESSION['success_message']) ? $_SESSION['success_message'] : '';
unset($_SESSION['success_message']); // Limpar a mensagem após usá-la

// Processo de autenticação do usuário
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["username"]) && isset($_POST["password"])) {
    $username = $_POST["username"];
    $password = $_POST["password"];

    // Verifica se as credenciais estão corretas
    if ($username === $config['usuario'] && $password === $config['senha']) {
        $_SESSION["username"] = $username;
        header('Location: admin.php'); // Redireciona para o painel de servidores
        exit;
    } else {
        $error_message = 'Usuário ou senha inválidos!';
    }
}

// Verifique se o formulário de configuração foi enviado
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['new_username']) && isset($_POST['new_password'])) {
    $config['usuario'] = $_POST['new_username'];
    $config['senha'] = $_POST['new_password'];

    // Processar o upload da imagem, se fornecido
    if (isset($_FILES['new_logo']) && $_FILES['new_logo']['error'] == UPLOAD_ERR_OK) {
        $target_dir = "img/"; // Pasta onde a imagem será salva
        $target_file = $target_dir . basename($_FILES["new_logo"]["name"]);
        $uploadOk = 1;
        $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

        // Verifica se o arquivo é uma imagem
        $check = getimagesize($_FILES["new_logo"]["tmp_name"]);
        if ($check === false) {
            $error_message = "O arquivo não é uma imagem.";
            $uploadOk = 0;
        }

        // Verifica o tamanho do arquivo
        if ($_FILES["new_logo"]["size"] > 500000) {
            $error_message = "Desculpe, a imagem é muito grande.";
            $uploadOk = 0;
        }

        // Permitir apenas certos formatos de imagem
        if ($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" && $imageFileType != "gif") {
            $error_message = "Desculpe, apenas arquivos JPG, JPEG, PNG e GIF são permitidos.";
            $uploadOk = 0;
        }

        // Verifica se o upload está definido para prosseguir
        if ($uploadOk == 1) {
            // Remove a imagem antiga se existir
            if (file_exists($config['logo'])) {
                unlink($config['logo']); // Remove a imagem antiga
            }

            if (move_uploaded_file($_FILES["new_logo"]["tmp_name"], $target_file)) {
                $config['logo'] = $target_file; // Atualiza o caminho da logo no config
                saveConfig($config);
                $_SESSION['success_message'] = "Configurações salvas com sucesso!";
                header("Location: admin.php");
                exit;
            } else {
                $error_message = "Desculpe, houve um erro ao fazer o upload da sua imagem.";
            }
        }
    } else {
        // Se não houver upload de imagem, apenas salve as alterações de usuário e senha
        saveConfig($config);
        $_SESSION['success_message'] = "Configurações salvas com sucesso!";
        header("Location: admin.php");
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Painel Responsivo com Dark Mode</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    tailwind.config = {
      darkMode: 'class'
    }
  </script>
</head>
<body class="bg-gray-100 dark:bg-gray-900">

  <!-- Cabeçalho -->
  <header class="w-full h-16 bg-white dark:bg-gray-800 shadow flex items-center justify-between px-6">
    <div class="flex items-center gap-4">
      <!-- Botão menu (aparece no mobile) -->
      <button id="menuToggle" class="block md:hidden text-2xl text-gray-700 dark:text-gray-200">
        ☰
      </button>
      <div class="text-2xl font-bold text-gray-700 dark:text-gray-100">Painel</div>
    </div>

    <div class="flex items-center gap-4">
      <button id="toggleDark" class="px-4 py-2 bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-200 rounded hover:bg-gray-300 dark:hover:bg-gray-600">
        🌙/☀
      </button>
      <div class="text-gray-500 dark:text-gray-300 hidden sm:block">Bem-vindo, <?php echo htmlspecialchars($config['usuario']); ?></div>
    </div>
  </header>

  <div class="flex">

    <!-- Menu Lateral -->
    <aside id="sidebar" class="w-64 bg-white dark:bg-gray-800 h-[calc(100vh-4rem)] shadow-md fixed md:static top-16 left-0 transform -translate-x-full md:translate-x-0 transition-transform duration-300 z-50">
      <nav class="flex flex-col p-4 space-y-2">
        <a href="dashboard.php" class="p-3 rounded hover:bg-blue-100 dark:hover:bg-blue-900 flex items-center">
          <span class="text-gray-700 dark:text-gray-200">🏠 Dashboard</span>
        </a>
        <a href="servidores.php" class="p-3 rounded hover:bg-blue-100 dark:hover:bg-blue-900 flex items-center">
          <span class="text-gray-700 dark:text-gray-200">🖥 Servidores</span>
        </a>
        <a href="admin.php" class="p-3 rounded hover:bg-blue-100 dark:hover:bg-blue-900 flex items-center">
          <span class="text-gray-700 dark:text-gray-200">👤 Admin</span>
        </a>
        <a href="logoutvs.php" class="p-3 rounded hover:bg-red-100 dark:hover:bg-red-900 flex items-center">
          <span class="text-red-600 dark:text-red-400">🚪 Sair</span>
        </a>
      </nav>
    </aside>

    <!-- Caixa de Conteúdo -->
    <main class="flex-1 p-6 w-full"> 
      <div class="bg-white dark:bg-gray-800 rounded-xl shadow-md p-6">
        <h2 class="text-2xl font-semibold mb-4 text-gray-800 dark:text-gray-100">Configurações</h2>

        <?php if (isset($error_message)): ?>
            <p class="text-red-500 text-center mb-4"><?php echo htmlspecialchars($error_message); ?></p>
        <?php endif; ?>

        <?php if ($success_message): ?>
            <p id="success-message" class="text-green-500 text-center mb-4"><?php echo htmlspecialchars($success_message); ?></p>
        <?php endif; ?>

        <form method="post" action="" class="space-y-4" enctype="multipart/form-data">
            <input type="text" name="new_username" placeholder="Novo Usuário" value="<?php echo htmlspecialchars($config['usuario']); ?>" required class="w-full p-2 mb-4 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-blue-500">
            <input type="text" name="new_password" placeholder="Nova Senha" value="<?php echo htmlspecialchars($config['senha']); ?>" required class="w-full p-2 mb-4 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-blue-500">
            <input type="file" name="new_logo" accept="image/*" class="w-full p-2 mb-4 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-blue-500">
            
            <!-- Exibir a imagem atual da logo -->
            <div class="mt-4">
                <h3 class="text-lg font-semibold text-gray-800 dark:text-gray-100">Logo Atual:</h3>
                <img src="<?php echo htmlspecialchars($config['logo']); ?>" alt="Logo" class="mt-2 h-20 w-auto">
            </div>
            
            <button type="submit" class="w-full py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Salvar</button>
        </form>
      </div>
    </main>

  </div>

  <!-- Script para Dark Mode e Menu -->
  <script>
    const toggleDark = document.getElementById('toggleDark');
    const html = document.documentElement;

    // Dark mode persistente
    if (localStorage.getItem('theme') === 'dark') {
      html.classList.add('dark');
    }

    toggleDark.addEventListener('click', () => {
      if (html.classList.contains('dark')) {
        html.classList.remove('dark');
        localStorage.setItem('theme', 'light');
      } else {
        html.classList.add('dark');
        localStorage.setItem('theme', 'dark');
      }
    });

    // Controle do menu mobile
    const menuToggle = document.getElementById('menuToggle');
    const sidebar = document.getElementById('sidebar');

    menuToggle.addEventListener('click', () => {
      sidebar.classList.toggle('-translate-x-full');
    });

    // Função para ocultar a mensagem após um tempo
    function hideMessage() {
      const messageElement = document.getElementById('success-message');
      if (messageElement) {
        setTimeout(() => {
          messageElement.style.opacity = '0';
          setTimeout(() => {
            messageElement.style.display = 'none';
          }, 500);
        }, 3000);
      }
    }

    document.addEventListener('DOMContentLoaded', hideMessage);
  </script>

</body>
</html>
